# CTC arrows
image ctc_blink1:
    "assets/basket_ctc1.png"
    linear 0.75 alpha 1.0
    linear 0.75 alpha 0.0
    repeat 

image ctc_blink2:
    "assets/flower_ctc1.png"
    linear 0.75 alpha 1.0
    linear 0.75 alpha 0.0
    repeat 

# Defined variables

# For gui dialogue text outlines
define gui.dialogue_text_outlines = [ (2, "#2c2c2c") ]

# For nvl mode ctc
define config.nvl_page_ctc = "ctc_blink2"
define config.nvl_page_ctc_position = "nestled"

# Declare characters used by this game. The color argument colorizes the
# name of the character.
define narrator = Character(name=None, kind=nvl, ctc="ctc_blink1", ctc_position="nestled", ctc_pause="ctc_blink1", ctc_timedpause="ctc_blink1")

#narrator for adv
define n = Character(name=None, ctc="ctc_blink2", ctc_position="nestled", ctc_pause="ctc_blink1", ctc_timedpause="ctc_blink1")

define r = Character(name="The Girl", ctc="ctc_blink2", ctc_position="nestled", ctc_pause="ctc_blink1", ctc_timedpause="ctc_blink1", who_color="#721817", who_outlines= [ (1, "#CBD4C2") ]) 
    # for ctc="ctc_blink2" is when there's nothing after the text, and ctc_pause="ctc_blink1" is when there is still text to be said.
    #who_outlines gives the character name outlines
define g = Character(name="Gretel", ctc="ctc_blink2", ctc_position="nestled", ctc_pause="ctc_blink1", ctc_timedpause="ctc_blink1", who_color="#7CCD81", who_outlines= [ (1, "#140105") ]) 

define g2 = Character(name="???", ctc="ctc_blink2", ctc_position="nestled", ctc_pause="ctc_blink1", ctc_timedpause="ctc_blink1", who_color="#7CCD81", who_outlines= [ (1, "#140105") ]) 

define rg = Character(name="The Girl & ???", ctc="ctc_blink2", ctc_position="nestled", ctc_pause="ctc_blink1", ctc_timedpause="ctc_blink1", who_color="#CBD4C2", who_outlines= [ (1, "#140105") ]) 

define w = Character(name="The Wolf", ctc="ctc_blink2", ctc_position="nestled", ctc_pause="ctc_blink1", ctc_timedpause="ctc_blink1", who_color="#2B4162", who_outlines= [ (1, "#CBD4C2") ])

define m = Character(name="The Witch", ctc="ctc_blink2", ctc_position="nestled", ctc_pause="ctc_blink1", ctc_timedpause="ctc_blink1", who_color="#622b62", who_outlines= [ (1, "#CBD4C2") ]) 



#### IMAGES THAT ARE BROKEN FOR SOME REASON??
image Gretel_awkward = "images/sprites/Gretel_sprites/Gretel_awkward.png"

image Gretel_confused= "images/sprites/Gretel_sprites/Gretel_confused.png"

image Gretel_dazed = "images/sprites/Gretel_sprites/Gretel_dazed.png"

image Gretel_dazed1 = "images/sprites/Gretel_sprites/Gretel_dazed1.png"

image Gretel_glance = "images/sprites/Gretel_sprites/Gretel_glance.png"

image Gretel_happy = "images/sprites/Gretel_sprites/Gretel_happy.png"

image Gretel_happy = "images/sprites/Gretel_sprites/Gretel_happy.png"

image Gretel_neutral = "images/sprites/Gretel_sprites/Gretel_neutral.png"

image Gretel_scared = "images/sprites/Gretel_sprites/Gretel_scared.png"

image Gretel_sob = "images/sprites/Gretel_sprites/Gretel_sob.png"



##### SCENE 3 STARTS HERE
label scene3:
    stop music fadeout 0.5

    play music "<loop 0>02放課後スリーピング.mp3" fadein 0.5

    show red_pain with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "I'll lose him in the depths of the woods, and then I'll just find my way back home..!"

    hide red_pain with dissolve

    "She went off the path entirely and hoped she had enough of a head start that the Wolf would lose her trail."
    nvl clear

    #### SCENE 3: GRETEL'S FAIRY TALE
    ####

    scene black 
    with fade
    $ renpy.pause(2.0, hard=True)

    stop music fadeout 0.5

    play music "<loop 0>Doormat (Musikbox).ogg" fadein 0.5

    scene gretel_intro1 with fade

    """
    There once was a princess who wanted her life to never change.

    This princess didn't need exciting or remarkable things to happen to her. 
    """
    nvl clear

    scene gretel_intro2 with fade

    """
    She lived happily in the kingdom with her family… and a prince. 

    She was always satisfied as long as she was with the people she loved. 
    """
    nvl clear

    scene gretel_intro3 with fade

    """
    Her prince insisted they'd be happier if they ran away together. 

    The princess didn't love the prince but worried about what would happen if he ran off by himself.  
    """
    nvl clear

    scene gretel_intro4 with fade

    """
    When the rest of the kingdom found out about the prince's plan to take the princess away, he was exiled. 

    The princess didn't want her life with the prince to end, so she decided to sneak out of the kingdom and find him. 

    """
    nvl clear

    window hide
    $ show_quick_menu = False

    scene black
    with fade
    $ renpy.pause(2.0, hard=True)

    stop music fadeout 0.5

    #### SCENE 4: RED AND GRETEL MEET
    ####

    play music "<loop 0>07水の精霊.ogg" fadein 0.5

    scene woods4
    $ show_quick_menu = True
    with fade

    """
    Something shifted in the air when the girl entered uncharted territory in the depths of the woods. 

    She felt as if she had crossed an invisible threshold.

    The air was maybe… lighter. The nature around her somehow felt more vibrant.  

    She had read about this sensation in books. 

    {clear}

    Magic was rare, but it did exist. Nobody in her village used magic, and most of them weren't interested in it either. 

    She had to rely on what information she could find in books and stories from travelers. 

    Her mother told her she was just wasting her time, but the girl couldn't help but fantasize about what she'd be able to accomplish if she had an affinity for magic. 

    Apparently spells left lingering traces in the air. 

    {clear}

    Different types of magic had different feelings, but she couldn't recall all the types right now. 

    The books she had access to also weren't written by actual mages or anything like that. They were just people recording their own encounters. 

    There were rumors about a witch living in the depths of the woods, but none of them were concerning.

    Nothing like the stories about wolves.

    {clear} 

    The girl planned on hurrying back home anyways, so she couldn't worry about a witch who may or may not exist. 

    The feeling that surrounded her might have just been relief at her escape. 

    Even though her guard was still up she felt safe enough to slow her pace. 

    The girl wasn't sure when they had stopped, but she could no longer hear footsteps behind her. 

    {clear}

    Of course stopping completely was risky, but all that running left her exhausted.

    Her hand rested against a tree while she caught her breath.

    """
    nvl clear

    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "(Maybe he gave up...)"

    hide red_neutral with dissolve

    """
    The respite gave her time to think about what was waiting for her once she actually got back. 

    The girl was so fixated on getting home that she failed to consider what would happen after that. 

    She'd have to tell her mother about her grandmother, and she might have to revisit that grizzly scene in the house. 
    """
    nvl clear

    show red_fear with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "(If the Wolf finished eating her then…)"

    hide red_fear with dissolve

    """
    They wouldn't even have anything to bury. 

    If she just presented the situation as a random attack and never told the truth then she'd have to live with that lie for the rest of her life. 

    A wolf attack would also only give her mother another reason to be overprotective. 

    It was a selfish thought, but without her grandmother she had no excuse for leaving the village.
    """
    nvl clear

    show red_despair with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "(Should I even go back..?)"

    hide red_despair with dissolve

    """
    She could always tell the truth, but that'd be even worse.

    "Why would you ever trust a wolf?"

    "How did I raise such an idiot?" 

    "You got your grandmother killed."

    "It's all your fault." 

    {clear}

    Her reputation already wasn't the best. 

    A lot of people in the village just knew her as the stubborn girl who wouldn't listen to her mother. 

    An unreasonable troublemaker who would make a terrible wife one day. 

    Or maybe everyone hoped a strong man would put her in her place. 

    {clear}

    She didn't have the chance to dwell on this for too much longer.

    """
    nvl clear

    stop music fadeout 0.5

    play music "<loop 0>11暗闇の鐘.ogg" fadein 0.5

    """
    The girl froze when she heard rustling in the brush ahead of her.

    Unsure of what to do, she grabbed a large stick that was in front of her and raised it like a weapon. 

    The effort was definitely pointless, but something was better than nothing right? 

    """
    nvl clear

    show red_freakedout with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "(How'd he get ahead of me?!)"

    r "I know it's you!"

    show red_angry with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_freakedout

    r "Get away from me!"

    r "(As if I could scare him off...)"

    g2 "Huh?"

    hide red_angry with dissolve

    stop music fadeout 0.5

    play music "<loop 0>18守り木の下で.ogg" fadein 0.5

    """
    An unfamiliar voice responded to her shouts.

    """
    window hide

    show Gretel_glance with dissolve:
        xalign 0.5
        yalign 0.999

    window show

    """

    A different girl emerged. 

    She had her arms up to show she meant no harm, but there was a confused look on her face.

    """
    nvl clear

    show red_confused with dissolve:
        xalign 0.07
        yalign 0.999
    
    show Gretel_awkward with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_glance
    
    g2 "Did you mistake me for someone else?"

    r "(Ah, that's embarrassing… )"

    hide red_confused with dissolve

    """
    She lowered the stick.

    This girl looked to be about her age, but she didn't recognize her. 

    """
    nvl clear

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "(She must be from another village or something…)"

    r "Not… exactly. Sorry, I'm just-"
    
    hide red_nervoussmile with dissolve

    """
    The girl struggled to figure out what to say. 

    It'd be easy to just say a wolf was chasing her, but that'd be leaving out a lot of key details. 

    Though a stranger didn't need to know everything. 

    If the girl shared her entire story then maybe this stranger would think what happened was entirely her fault.

    {clear} 

    "Why would you trust a wolf?" 

    The girl wondered if being with someone else might deter the Wolf, or if he'd be willing to devour this other girl to get what he wanted. 

    She'd feel a lot safer with an escort back home though.

    """
    nvl clear

    show red_nervous with dissolve:
        xalign 0.07
        yalign 0.999
    
    show Gretel_confused with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_awkward
    
    rg "I need help-"
    
    hide red_nervous with dissolve

    "Both girls seemed surprised."
    nvl clear

    show red_confused with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "Huh?"

    show Gretel_neutral with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_confused

    g2 "Sorry, I might be getting ahead of myself."

    show Gretel_happy with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_neutral

    g "My name's Gretel."

    show Gretel_glance with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_happy

    g "My brother, Hansel, and I… we both got lost in the woods. "

    g "This might sound weird, but we stumbled upon a house belonging to a witch…"

    g "At first everything seemed fine, but…"

    g "But my brother won't leave. I snuck out and was hoping… I could find someone to help me get him out."
    
    hide red_confused with dissolve

    """
    The girl was kind of… half listening to what the other was saying. 

    Of course the witch ended up being real. 

    She picked up on the other's name and the reason why she was so deep in the woods, but seeing someone else was sort of a shock to her system. 

    Now that she had stopped running, she was able to fully process everything that had just happened to her. 

    """
    nvl clear

    stop music fadeout 0.5

    play music "<loop 0>05不思議な絵本.ogg" fadein 0.5

    "Tears started to well in her eyes, and it clearly caught Gretel off guard."
    nvl clear

    show red_despair with dissolve:
        xalign 0.07
        yalign 0.999

    show Gretel_awkward with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_glance
    
    g "Hey? Are you okay?"

    r "(Oh my god... grandma is really dead… and the Wolf-)"

    hide red_despair with dissolve

    """
    She dropped her makeshift weapon and stepped closer to Gretel. 

    Without thinking about the consequences she ended up clinging to the other girl and sobbing. 

    """
    nvl clear

    show red_despair with dissolve:
        xalign 0.07
        yalign 0.999

    r "I… I…"

    r "I'm running from a wolf!"

    r "He- it, killed my grandma. He might still be chasing me, and I don't know what to do and-!"

    hide red_despair with dissolve

    """
    The girl got ready to be shoved off. 

    What was she doing crying into the chest of a stranger like this? 

    She didn't expect comforting hands to rest on her shoulders. 
    """
    nvl clear

    show red_despair with dissolve:
        xalign 0.07
        yalign 0.999

    show Gretel_glance with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_awkward

    g "Ah… it's going to be okay?"

    hide red_despair with dissolve

    "The other made an attempt to calm her down, which was more than she was obligated to do."

    show red_despair with dissolve:
        xalign 0.07
        yalign 0.999

    g "I mean- well, I'm sorry… I don't really know what to say. "

    g "You got away, right?"

    hide red_despair with dissolve

    """
    The girl nodded her head with a sniffle. 

    She was too overwhelmed to feel ashamed of her actions, but if she was a little more self-conscious then she'd be feeling absolutely pathetic right now. 

    """
    nvl clear

    show red_despair with dissolve:
        xalign 0.07
        yalign 0.999

    show Gretel_neutral with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_glance

    g "I don't think he'll follow you here, though. "

    hide red_despair with dissolve

    "The girl lifted her head and looked up at Gretel with wide eyes."
    nvl clear

    show red_confused with dissolve:
        xalign 0.07
        yalign 0.999

    r "What do you mean?"

    g "Because of the magic in the air, I mean."

    show Gretel_happy with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_neutral

    g "I bet that'll scare him off."

    r "…You really think so?"

    show Gretel_glance with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_happy

    g "Well, I can't be positive, but I just have a hunch."

    hide red_confused with dissolve

    """
    A hunch was better than nothing, at least. 

    After a few moments of silence, the girl pulled away and quickly wiped at her eyes. 

    """
    nvl clear

    stop music fadeout 0.5

    play music "<loop 0>02小さな魔術書.ogg" fadein 0.5

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999

    r "S-sorry, I just got a bit overwhelmed."

    show Gretel_awkward with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_glance

    g "…It's fine! Honestly I was a little close to doing the same."

    hide red_nervoussmile with dissolve

    "Gretel looked down and nervously scratched the back of her head."
    nvl clear

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999

    g "I feel kind of bad asking for your help when you've been through so much, but I don't think I can get my brother back without some help."

    hide red_nervoussmile with dissolve

    """
    The girl finally fully processed what had been said to her earlier. 

    So the witch was dangerous? 

    Just her luck. 

    How could she help though? 

    Maybe Gretel just planned on using her as a distraction.

    """
    nvl clear

    show red_pain with dissolve:
        xalign 0.07
        yalign 0.999

    r "(I might deserve that… after everything.)"

    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_pain

    r "I'm not sure what I'd be able to do to help."

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_neutral

    r "I barely know a thing about magic, and I'm a little shaken up right now…"

    g "Don't worry! I've uh, got a plan."

    r "What is it?"

    show Gretel_scared with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_awkward

    g "I'm pretty sure the witch cast some kind of spell on my brother. That's why he won't leave!"

    show Gretel_glance with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_scared

    g "But I bet if I can get him out of the house or away from the witch, the spell might stop working."

    show red_fear with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_nervoussmile

    r "Are you… sure about that?"

    g "I'm not an expert when it comes to magic, but it has to have limits."

    show red_confused with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_fear

    r "And what do I do?"

    hide red_confused with dissolve

    "There was a pause as Gretel considered what to say."
    nvl clear

    show red_confused with dissolve:
        xalign 0.07
        yalign 0.999

    show Gretel_awkward with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_glance
    
    g "I wouldn't be able to get anything done if the witch is breathing down my neck, so…"

    r "You want me to distract her?"

    hide red_confused with dissolve

    "Gretel's hands came together in an apologetic gesture."
    nvl clear

    show red_confused with dissolve:
        xalign 0.07
        yalign 0.999
    
    g "Kind of, yeah! I'm sorry-"

    g "I get it if you don't want to."

    show Gretel_scared with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_awkward

    g "My brother is just really important to me, and I'm not sure what else to do."

    show red_pain with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_confused

    r "(One person is dead because of me. Maybe I should try to save someone else.)"

    r "(If there had been a way to protect grandma, I'd probably ask the same thing.)"

    hide red_pain with dissolve

    "The girl thought for a moment, and then nodded."
    nvl clear

    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "Um, okay."

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_neutral

    r "I'll do my best. I'm not really sure if I can play the part well."

    show Gretel_happy with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_scared

    g "Really?!"

    hide red_nervoussmile with dissolve

    stop music fadeout 0.5

    play music "<loop 0>Doormat (Musikbox).ogg" fadein 0.5

    "Gretel stepped forward and pulled the girl into a hug."
    nvl clear

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999
    
    g "Thank you!"

    hide red_nervoussmile with dissolve

    """
    Her relief was genuine and obvious. 

    The girl would be lying if she didn't admit that the touch helped ground her even more. 

    Though she wasn't sure if returning the hug or putting her arms around Gretel would be strange. 

    The hug didn't last long enough for her to agonize over it for too much. 

    Gretel's hands lingered on her shoulders once she ended her embrace. 

    """
    nvl clear

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999

    show Gretel_neutral with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_happy
    
    g "About that wolf… my brother is actually a hunter!"

    g "I'm sure he can handle one wolf."

    g "We'll make sure you get home safe!"
    
    hide red_nervoussmile with dissolve

    stop music fadeout 0.5

    play music "<loop 0>18守り木の下で.ogg" fadein 0.5

    """
    The girl was still worried about leading not one but two other people to their demise, but maybe her fear was causing her to overestimate the threat that the Wolf posed. 

    If Gretel said her brother was a hunter, then the girl would trust his skills. 

    Sure, he had gotten caught by a witch, but witches and wolves were probably different enough.

    """
    nvl clear

    show red_confused with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "So uh, where is this witch?"

    g "There's this house made out of candy a bit deeper in the woods."

    r "Candy?"

    show Gretel_glance with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_happy

    g "Well, it might not be actual candy, but you know… magic and all that."

    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_confused

    r "Right… "

    r "Well, lead the way."

    hide red_neutral with dissolve

    scene woods5 with fade

    #### SCENE 5: ARRIVING AT THE WITCH'S HOUSE
    ####

    show Gretel_neutral with dissolve:
        xalign 0.5
        yalign 0.999

    """
    The girl stayed close to Gretel's side as they walked. 

    Again she felt bad being overly familiar with a stranger, but it helped her feel safe. 

    She regularly looked over her shoulder and turned in the direction of any distinct sounds.

    Gretel noticed her anxious behavior.
    """
    nvl clear

    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999
    
    g "Like I said, we'll be fine."

    hide red_neutral with dissolve

    "She extended her hand for the girl to take."
    nvl clear

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999
    
    g "Here. Will this help you feel safer?"

    hide red_nervoussmile with dissolve

    "The girl nodded and reached out to take the offered hand."
    nvl clear

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "Thanks..."

    hide red_nervoussmile with dissolve

    scene woods2 with fade

    show Gretel_neutral with dissolve:
        xalign 0.5
        yalign 0.999

    "The two continued their journey in silence, which stirred up a different kind of nervousness in the girl."
    nvl clear

    show red_confused with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "(I'm trusting a complete stranger here.)"

    r "(What if she's lying about there even being a witch? Does she really have a brother?)"

    hide red_confused with dissolve

    """
    The girl felt that Gretel's plea had been earnest enough, but of course she was on edge. 

    Her mother had told her stories about bandits and kidnappers as well.

    But Gretel didn't look like the type. 

    Though now the girl couldn't help but wonder if her mother's stories were just attempts to make their village seem like the only safe place for her. 
    """
    nvl clear


    show red_pain with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "(Too dangerous for me to wander off, but safe enough to travel alone?)"

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_pain

    r "(Thanks mom.)"
    
    hide red_nervoussmile with dissolve

    "The girl knew she'd be relieved to see her mother once this ordeal was done, but they'd probably have quite the fight once the sentimentality wore off."
    nvl clear


    show red_nervous with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "(Ack- I've been quiet for way too long.)"

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_nervous

    r "So um, it's kind of funny we're around the same age but have never met before."

    r "Do you live in another village?"

    hide red_nervoussmile with dissolve

    "The girl was pretty sure her town was the only one in these woods, but now she wasn't certain of anything."
    nvl clear


    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999

    g "No, my family just lives alone."

    g "We're kind of close to where the forest ends and have a little farm."

    g "There's a city about two days travel from there."

    g "My dad and my brother go there to sell what we grow and get supplies for the house."

    hide red_nervoussmile with dissolve

    """
    An isolated home couldn't help remind the girl of her grandmother, but at least this was a whole family living together.

    She knew about the city from traveler's stories, but her mother wouldn't let her go. 

    The girl wanted to ask if Gretel had been and get more stories about the liberated life that had been denied to her.

    """
    nvl clear
    window hide

    stop music fadeout 0.5

    play music "<loop 0>01扉の向こう.ogg" fadein 0.5

    scene witch house with fade

    show Gretel_neutral with dissolve:
        xalign 0.5
        yalign 0.999

    window show

    """
    Her curiosity was swiftly dampened by a building coming into view. 

    Nestled between some large trees was a rather nice home.

    It seemed too big for just one person, witch or not. 

    Though the girl didn't understand why Gretel said it was made of candy. 

    """
    nvl clear

    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "This is it?"

    show Gretel_glance with dissolve:
        xalign 0.5
        yalign 0.999
    hide Gretel_neutral

    g "Mhmm. Kind of weird, huh?"

    g "I've never seen anything like it."

    hide red_neutral with dissolve

    hide Gretel_glance with dissolve

    """
    The girl squinted, trying to see what she was missing. 

    Was it possible that the candy just looked like the regular exterior of a house, or maybe the magic was hiding its true nature?

    The odd feeling in the air was certainly stronger here, and she thought she smelled something sweet. 

    Though it could have just been someone baking something from inside the house. 

    """
    nvl clear

    show Gretel_neutral with dissolve:
        xalign 0.5
        yalign 0.999

    show red_confused with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "So… what's your plan, exactly?"

    g "You'll see. All you need to do is follow my lead."
    
    hide red_confused with dissolve

    "That didn't reassure the girl in the slightest."
    nvl clear

    #### SCENE 6: THE GIRLS ENTER THE HOUSE
    ####

    """
    Gretel walked up to the front door first.

    The girl trailed behind and again tried to see what she might be missing about the house.

    Gretel gave her a reassuring look before she reached out to knock on the door. 

    The girl made an attempt at a convincing smile. 
    """
    nvl clear

    stop music fadeout 0.5

    play music "<loop 0>02小さな魔術書.ogg" fadein 0.5

    """
    The door swung open after just one knock. 

    An even sweeter, almost sickening smell filled the air as a woman stepped out and joined them on the porch. 

    """
    nvl clear

    show Gretel_neutral with easeinright:
        xalign 0.7
        yalign 0.999

    show witch_surprise with dissolve:
        xalign 0.5
        yalign 0.999

    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999
    
    m "Gretel! There you are!"

    m "I've been worried sick about you."
    
    hide red_neutral with dissolve

    "The woman, presumably the Witch, pulled Gretel into an embrace."
    nvl clear

    show red_nervous with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "(Huh? What's going on here?)"

    m "You just vanished after dinner!"

    show witch_glance with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_surprise 

    m "Your brother spent all night looking for you. I think he caught a cold or something…"

    m "He didn't come back until after sunrise, and has been resting ever since."

    show Gretel_confused with dissolve:
        xalign 0.7
        yalign 0.999
    hide Gretel_neutral

    g "Hansel's… sick? But-"

    hide red_nervous with dissolve

    "The Witch pulled away from their hug and gave Gretel an encouraging pat on the shoulder."
    nvl clear

    show witch_neutralsmile with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_glance

    show red_nervous with dissolve:
        xalign 0.07
        yalign 0.999
    
    m "Oh don't start worrying. I've been taking care of him."

    m "It's nothing serious."

    hide red_nervous with dissolve

    "Her gaze fell upon the girl, who did her best to not immediately flinch."
    nvl clear

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999

    show witch_neutral with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_neutralsmile
    
    m "And… who is this?"

    r "Ah, I'm-"

    hide red_nervoussmile with dissolve

    """
    The girl stumbled over her words and tried to think how she should respond.

    Was it safe to give her name to a witch?{w} Didn't names have power in magic or was she thinking of something else? 
    """
    nvl clear

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999

    show Gretel_awkward with dissolve:
        xalign 0.7
        yalign 0.999
    hide Gretel_confused
    
    g "This is a friend of mine!"

    hide red_nervoussmile with dissolve

    "Thankfully Gretel swiftly cut in."
    nvl clear

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999
    
    g "I uh… I'm sorry I left! But I bumped into her on my way back!"

    show Gretel_neutral with dissolve:
        xalign 0.7
        yalign 0.999
    hide Gretel_awkward

    g "It was a really nice coincidence."

    hide red_nervoussmile with dissolve

    """
    The girl just nodded. She figured she should go along with whatever Gretel said even if she was in the dark about her plan. 

    The Witch silently stared at them for just a little too long to be comfortable before smiling.
    """
    nvl clear

    show witch_suspicious with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_neutral
    
    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999
    
    show witch_smile with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_suspicious
    
    m "I see. Well, the more the merrier!"

    m "I'm glad you found someone. Things are little dangerous if you wander outside of my neck of the woods."

    show witch_surprise with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_smile

    m "Oh but, where are my manners? I'm making the two of you stand outside like this!"

    show witch_neutralsmile with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_surprise

    m "Please, come in. I'll fix us all some tea and snacks."

    r "Oh that's really kind of you, but I…"

    hide red_nervoussmile with dissolve

    """
    The girl recalled a quick flash of gore and felt her stomach tie into knots. 

    She wanted to make an excuse about already eating but realized she no longer had her basket. 
    """
    nvl clear


    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "(I guess I dropped it at some point.)"

    show red_pain with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_nervoussmile

    r "I'm not that hungry."

    show witch_neutral with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_neutralsmile

    m "Alright, just tea then."

    hide red_pain with dissolve

    stop music fadeout 0.5

    scene witch interior with fade

    play music "<loop 0>25遠くで頭のぬいぐるみがこっちにくるの.mp3" fadein 0.5

    show Gretel_neutral with dissolve:
        xalign 0.8
        yalign 0.999

    show witch_neutral with dissolve:
        xalign 0.6
        yalign 0.999

    """
    The Witch stepped aside and ushered both girls into her home. 

    As she passed by the Witch, the girl caught an even more intense sweet smell. It felt strong enough to give her a headache if enough time passed.
    """
    nvl clear

    show red_confused with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "Is that a perfume?"

    hide red_confused with dissolve

    """
    The Witch closed the door once everyone was inside and gestured for the two to follow her. 

    The girl was still focused on Gretel's comment about the place being made of candy, but everything still looked normal to her. 

    Well, she did want to ask the witch about the books and bottles on her shelves, but now really didn't seem like the time. 

    {clear}

    She could use her role as distraction to learn more about magic, though the girl wasn't sure how much of her guard should be up. 

    Gretel's guidance to follow her lead certainly didn't help. The other girl now seemed almost completely relaxed. 

    It was a far cry from the nervous figure who had asked for her assistance just moments earlier. 

    The Witch stopped in front the entrance to a different hallway.
    """
    nvl clear

    scene witch hallway

    show Gretel_neutral with dissolve:
        xalign 0.8
        yalign 0.999

    show witch_smile with dissolve:
        xalign 0.6
        yalign 0.999

    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999
    
    m "Okay dear, Hansel is sleeping in the bedroom at the end of this hall."

    hide red_neutral with dissolve

    "Gretel nodded."
    nvl clear

    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999
    
    show Gretel_happy with dissolve:
        xalign 0.8
        yalign 0.999
    hide Gretel_neutral

    g "Thank you so much for taking care of him."

    show witch_neutralsmile with dissolve:
        xalign 0.6
        yalign 0.999
    hide witch_smile

    m "Don't be silly!"

    m "Of course I'd make sure he's alright. You're all my guests."

    hide red_neutral with dissolve

    """
    Gretel turned down the hallway, and the girl moved to follow her. 

    She was stopped by a hand coming to rest on her shoulder. The motion was swift and firm.

    """
    nvl clear

    hide Gretel_happy with dissolve

    show witch_neutralsmile with easeinleft:
        xalign 0.5
        yalign 0.999

    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999
    
    show witch_suspicious with dissolve:
        xalign 0.6
        yalign 0.999
    hide witch_neutralsmile
    
    m "Ah, you should probably give them some alone time don't you think?"

    show witch_smile with dissolve:
        xalign 0.6
        yalign 0.999
    hide witch_suspicious

    m "Come with me to the kitchen. I'm still going to make some tea."

    hide red_neutral with dissolve

    """
    The girl nodded, afraid to protest. 

    She watched Gretel disappear into an open door before following the Witch into her kitchen. 

    It was thankfully only a short walk from the hall Gretel had gone down.
    """
    nvl clear

    #### SCENE 7: RED AND THE WITCH IN THE KITCHEN
    ####

    stop music fadeout 0.5

    scene witch kitchen with fade

    play music "<loop 0>25遠くで頭のぬいぐるみがこっちにくるの.mp3" fadein 0.5

    show witch_neutral with dissolve:
        xalign 0.5
        yalign 0.999

    """
    The girl expected the sweet aroma from before to be even stronger in the kitchen, but she couldn't find any signs recent signs of cooking or baking. 

    The Witch pulled out a chair at her table, and the girl sat. 

    """
    nvl clear

    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999
    
    show witch_glance with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_neutral
    
    m "And you're sure you're not hungry? I don't mind preparing anything you might like."

    r "I'm alright, thank you."

    show witch_neutral with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_glance

    m "Give me a second to get the tea going then."
    
    hide red_neutral with dissolve

    """
    As the Witch turned to her stove, the girl couldn't help but continue to admire the jars and bottles that lined some of the shelves. 

    She couldn't identify all of them, but a few of them contained dried plants she had read about and even encountered on her trips.

    """
    nvl clear

    show red_confused with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "(Are these for potions and magic?)"

    hide red_confused with dissolve

    """
    It was hard not to imagine the Witch standing over a pot, tossing in ingredients, and saying some kind of incantation. 

    Though that image was different from what was in front her now: a woman humming as she scooped tea leaves into a pot. 

    """
    nvl clear

    stop music fadeout 0.5

    play music "<loop 0>17チクタク時計が回ってるの.mp3" fadein 0.5

    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999
    
    show witch_neutralsmile with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_neutral

    m "And how do you prefer your tea?"

    r "However you have it should be fine."

    hide red_neutral2 with dissolve

    "The Witch chuckled before turning back to face the girl."
    nvl clear


    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999
    
    show witch_suspicious with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_neutralsmile

    m "How polite of you."

    show witch_neutral with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_suspicious

    m "But you really should tell me what you like."

    show witch_neutralsmile with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_neutral

    m "I prefer things to be… very sweet. It's usually not what my guests like."

    m "Well, your friend actually enjoyed quite a bit of honey with hers."

    m "If you have similar tastes to hers then you should be fine."

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_neutral

    r "Oh, she did?"

    show witch_glance with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_neutralsmile

    m "You didn't know she had a sweet tooth?"

    show red_nervous with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_nervoussmile

    r "(Ah-)"

    r "(Was that on purpose? Was she trying to back me into a corner?)"

    r "(Maybe it's kind of obvious we aren't friends, but…)"

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_nervous

    r "Well! Of course I knew about the sweets."

    r "At my place, we normally just have sugar cubes, so I wasn't sure if she also liked honey."

    show witch_neutral with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_glance

    m "Of course."

    hide red_nervoussmile with dissolve

    """
    The girl was tense. She didn't want that to be obvious, but what would happen if the two got caught in their lie? 

    She hoped that Gretel had already woken her brother up and that the two were out of the house by now. 

    Her focus returned to the Witch when she sat down at the table with her. 
    """
    nvl clear

    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999
    
    show witch_glance with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_neutral
    
    m "You know, I love company but I don't get guests very often."

    show witch_neutralsmile with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_glance

    m "I can't remember the last time I had this many people in my house."

    show red_confused with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_neutral

    r "(Is three really a lot?)"

    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_confused

    r "Well, you have a really nice place here."

    show witch_smile with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_neutralsmile

    m "You think so? Thank you!"

    show witch_neutral with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_smile

    m "I agonized over how to decorate it for the longest time. "
    
    m "Does anything in particular stand out to you?"

    hide red_neutral with dissolve

    """
    The girl wasn't sure what to say. 

    She remembered what Gretel said before. This house was apparently made of candy, even if she couldn't see it. 

    Any curious traveler would stop in if they saw something like that, right? Or maybe it would scare people off. 

    """
    nvl clear

    show red_confused with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "(It looks normal to me! What does that mean?)"

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_confused

    r "It's… all so well put together."

    hide red_nervoussmile with dissolve

    "The Witch chuckled again."
    nvl clear

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999

    show witch_smile with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_neutral
    
    m "I'm putting you on the spot, aren't I?"

    show witch_neutral with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_smile

    m "Here- what do you think of that painting?"

    hide red_nervoussmile with dissolve

    """
    She turned around in her chair and gestured to a painting on the wall behind her. 

    It was a nice depiction of some flowers. The girl figured she would have been able to appreciate it more if her heart wasn't about to beat out of her chest.

    """
    nvl clear

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "It's lovely."

    show witch_smile with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_neutral

    m "Thank you. It was a gift."

    show witch_neutral with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_smile

    m "And the light above us?"

    hide red_nervoussmile with dissolve

    """
    Just above the table was a quaint chandelier holding several candles. 

    There were some glass crystals dangling from it as well.

    """
    nvl clear

    show red_happy with dissolve:
        xalign 0.07
        yalign 0.999

    r "It's really charming!"
    
    hide red_happy with dissolve

    """
    If she squinted maybe she could see the glass as candy, but wouldn't the heat from the candles melt it?

    She worried the Witch was going to ask her more questions about the decor, but the teapot whistled as if it was aware of her anxiety. 
    """
    nvl clear

    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999

    m "There's the tea. I'll get that."
    
    hide red_neutral with dissolve

    """
    The Witch poured two cups and brought them to the table.

    Her tea set had a pattern on it that reminded the girl of a lollipop. Looking into the center of her cup, she found a swirling pattern at the bottom. 

    The furniture in the house did sort of resemble candy if she thought about it.

    {clear} 

    Cream colored trims on the walls looked a bit like frosting, and the dark wood of the doors were kind of like chocolate. 

    Would her tea cup give way like candy if she bit into it?

    """
    nvl clear

    show red_confused with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "(Maybe Gretel was just mistaken…)"

    r "(But who mistakes regular furniture for candy?)"

    hide red_confused with dissolve

    "She was presented with a bowl of sugar cubes, some honey, and a dish of lemon slices."
    nvl clear

    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999
    
    show witch_neutralsmile with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_neutral
    
    m "Help yourself."
    
    hide red_neutral with dissolve

    
    "The Witch smiled at her before filling her cup with sugar cubes." 

    show witch_neutral with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_neutralsmile

    "She added them one at time and acted casually about it even once the number was in the double digits."
    
    nvl clear

    show red_nervous with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "(She was not kidding about the sweet tooth…)"
    
    hide red_nervous with dissolve

    """
    The girl opted for a little bit of honey and one lemon slice. 

    The tea smelled great, but something was telling the girl not to drink it. 

    She remembered what Gretel said about Hansel maybe having some type of spell on him. 

    Would she fall ill or refuse to leave this place if she drank from this cup? 

    """
    nvl clear
    
    show red_nervous with dissolve:
        xalign 0.07
        yalign 0.999

    show witch_surprise with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_neutral

    m "Something the matter?"

    hide red_nervous with dissolve

    "The Witch noticed the girl hadn't taken a sip from her cup yet."
    nvl clear

    show red_nervoussmile with dissolve:
        xalign 0.07
        yalign 0.999

    r "Oh… I'm just letting it cool."

    show witch_neutral with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_surprise

    m "Of course."

    hide red_nervoussmile with dissolve

    """
    The atmosphere in the kitchen was oppressive. 

    The girl felt as if one wrong move would spell her doom at the hands of the Witch, whatever form that might take.

    She flinched when the Witch suddenly stood from the table. 
    """
    nvl clear

    show red_neutral with dissolve:
        xalign 0.07
        yalign 0.999
    
    m " I hope it's not rude of me, but I just remembered something I need to take care of."

    show witch_neutralsmile with dissolve:
        xalign 0.5
        yalign 0.999
    hide witch_neutral

    m "If you do find yourself getting hungry then help yourself to anything in the cabinets."

    r "…Thank you."

    hide red_neutral with dissolve

    hide witch_neutralsmile with dissolve

    stop music fadeout 0.5

    play music "<loop 0>10パンドラの箱症候群.mp3" fadein 0.5

    """
    She exhaled a held breath once she was certain the Witch was gone. 

    So much for being an effective distraction, but if all Gretel had to do was wake her brother and lead him out then maybe that was enough time. 

    The Witch could potentially catch them in the act, and the girl didn't want to even imagine what would happen after that. 

    """
    nvl clear

    show red_confused with dissolve:
        xalign 0.07
        yalign 0.999
    
    
    r "(Should I check on them..?)"

    hide red_confused with dissolve

    """
    She was getting a bit worried but was also afraid of bumping into the Witch on her way to the other hallway. 

    It's not like she was explicitly told not to wander around, but there was a controlling implication behind every word the Witch spoke. 

    She was pulled out of her thoughts by the sound of footsteps.

    """
    nvl clear

    show red_nervous with dissolve:
        xalign 0.07
        yalign 0.999

    r "(She's back already?)"

    hide red_nervous with dissolve

    "The girl was about to fake a sip of her tea before noticing it was a familiar face at the kitchen's entrance."

    show Gretel_dazed with dissolve:
        xalign 0.5
        yalign 0.999

    "Gretel stood there silently."
    nvl clear

    show red_upset with dissolve:
        xalign 0.07
        yalign 0.999

    r "What are you doing?"

    hide red_upset with dissolve

    "The girl spoke in a hushed tone."
    nvl clear

    show red_upset with dissolve:
        xalign 0.07
        yalign 0.999

    g "I'm…"

    g "Uh-"

    show Gretel_glance with dissolve:
        xalign 0.5
        yalign 0.999
    
    hide Gretel_dazed with dissolve

    g "I was going to bring some food to Hansel."

    g "He can't leave until he's feeling better."

    show red_freakedout with dissolve:
        xalign 0.07
        yalign 0.999
    hide red_upset

    r "What? Then what were you doing that whole time?"

    show Gretel_dazed1 with dissolve:
        xalign 0.5
        yalign 0.999

    hide Gretel_glance

    g "…I didn't want to wake him. The Witch said he needed his rest."
    
    hide red_freakedout with dissolve

    "The girl was frustrated, but she also couldn't help but notice how strange Gretel was acting."
    nvl clear

    show red_confused with dissolve:
        xalign 0.07
        yalign 0.999
    
    r "(Is she shaken up by the state Hansel is in…?)"

    r "But isn't it just a cold?"

    hide red_confused with dissolve

    """
    Gretel's behavior reminded the girl of her own panicked state when she found her grandmother.

    While that had been earlier that day it also felt like an eternity ago.
    """
    nvl clear

    show red_confused with dissolve:
        xalign 0.07
        yalign 0.999

    r "(I'm not sure if I can trust Gretel to handle this…)"

    hide red_confused with dissolve

    window hide
    menu:
        "A. Check on Hansel alone":
            jump no_peeking
        "B. Confront Gretel":
            jump confront_gretel

    return