# MIT License

# Copyright (c) 2024 Chris

# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

## The init offset statement causes the initialization statements in this file
## to run before init statements in any other file.
init offset = -2

init python:
    import random
##############################################################################
# This function is optional. Only include it if you want automatic pauses between punctuation
    def typography(what):
        replacements = [
                ('. ','. {w=.1}'), # Moderate pause after periods
                ('? ','? {w=.15}'), # Long pause after question marks
                ('! ','! {w=.15}'), # Long pause after exclamation marks
                (', ',', {w=.05}'), # Short pause after commas
                ('; ',', {w=.08}'), # Short pause after semicolons
                (': ',', {w=.05}'), # Short pause after colons
        ]
        for item in replacements:
            what = what.replace(item[0],item[1])
        return what
    config.say_menu_text_filter = typography # This ensures the text block has the same ID value, even after all the replacements are made
##############################################################################

##############################################################################
    # This function makes the continuous text sounds
    # def text_sounds(event, interact=False, **kwargs):
    #     if event == "show":  # When textbox is shown
    #         what = renpy.store._last_say_what # This grabs the text that was most recently spoken on-screen
    #         if what:
    #             sound_count = len(what)
    #         else:
    #             sound_count = 5

    #         for _ in range(sound_count): # This creates a sound queue based on how many characters are in the dialogue block
    #             randosound = renpy.random.randint(1, 11) # This generates a random number between 1 and 11 inclusive. Change this based on how many sound files you have
    #             renpy.sound.queue(f"audio/popcat{randosound}.ogg", channel="yap", loop=False) # Change "popcat" to the name of your sound file

    #     elif event == "end" or event == "slow_done":
    #         renpy.sound.stop(channel="yap") # This stops the text sounds if there is a pause in the dialogue or the text has finished displaying

    #         randosound = renpy.random.randint(1, 11) # This generates a random number between 1 and 11 inclusive. Change this based on how many sound files you have
    #         renpy.sound.play(f"audio/popcat{randosound}.ogg", channel="yap", loop=False) # This plays one final uninterrupted sound at the end of the dialogue block
            
##############################################################################

##############################################################################
    # NARRATOR sounds (only plays a sound at the end of the text, or during a pause in it)
    def narrator_sounds(event, interact=False, **kwargs):
        if event == "end":
            renpy.sound.stop(channel="yap") # This stops the text sounds if there is a pause in the dialogue or the text has finished displaying

            renpy.sound.play(f"audio/ui/cutter.ogg", channel="yap", loop=False) # This plays one final uninterrupted sound at the end of the dialogue block
            
##############################################################################

##############################################################################
    # LOU sounds
    def lou_sounds(event, interact=False, **kwargs):
        if event == "slow_done":
            renpy.sound.stop(channel="yap") # This stops the text sounds if there is a pause in the dialogue or the text has finished displaying

            renpy.sound.play(f"audio/yap/lou1.ogg", channel="yap", loop=False) # This plays one final uninterrupted sound at the end of the dialogue block
            
##############################################################################

##############################################################################
    # CYNTHIA sounds
    def cynthia_sounds(event, interact=False, **kwargs):
        if event == "slow_done":
            renpy.sound.stop(channel="yap") # This stops the text sounds if there is a pause in the dialogue or the text has finished displaying

            renpy.sound.play(f"audio/yap/cynthia1.ogg", channel="yap", loop=False) # This plays one final uninterrupted sound at the end of the dialogue block
            
##############################################################################

##############################################################################
    # GARLAND sounds
    def garland_sounds(event, interact=False, **kwargs):
        if event == "slow_done":
            renpy.sound.stop(channel="yap") # This stops the text sounds if there is a pause in the dialogue or the text has finished displaying

            renpy.sound.play(f"audio/yap/garland1.ogg", channel="yap", loop=False) # This plays one final uninterrupted sound at the end of the dialogue block
            
##############################################################################

##############################################################################
    # BEAST sounds
    def beast_sounds(event, interact=False, **kwargs):
        if event == "slow_done":
            renpy.sound.stop(channel="yap") # This stops the text sounds if there is a pause in the dialogue or the text has finished displaying

            renpy.sound.play(f"audio/yap/beast1.ogg", channel="yap", loop=False) # This plays one final uninterrupted sound at the end of the dialogue block