
## Preferences screen ##########################################################
##
## The preferences screen allows the player to configure the game to better suit
## themselves.
##
## https://www.renpy.org/doc/html/screen_special.html#preferences

## Preference Variables
default persistent.char_animations = "all"
default persistent.autohighlight = True

screen preferences():

    tag menu

    default curr_screen = "general"

    add HBox(Transform("#0a0a0f", xsize=350), "#10131a") # The background; can be whatever

    use game_menu(_("Settings"))

    fixed:
        ## TABS 
        hbox:
            style_prefix "pref"

            textbutton _("General"):
                selected curr_screen == "general"
                action SetScreenVariable("curr_screen", "general")

            # add "gui/dia_separator.webp" yalign 0.5

            textbutton _("Text"):
                selected curr_screen == "text"
                action SetScreenVariable("curr_screen", "text")

            # add "gui/dia_separator.webp" yalign 0.5

            textbutton _("Sound"):
                selected curr_screen == "sound"
                action SetScreenVariable("curr_screen", "sound")


            
        showif curr_screen == "general":
            use pref_general()
        showif curr_screen == "sound":
            use pref_sound()
        showif curr_screen == "text":
            use pref_text()



screen settings(title):
    hbox:
        xsize 1570
        xpos 400
        label title xsize 475
        fixed:
            xsize 600
            ysize 50
            xpos -0.25
            hbox:
                spacing 30
                xalign 0.0
                transclude


############################################################
### PREFERENCE - general SCREEN ###
############################################################
screen pref_general():

    vbox:
        null height 140
        spacing 20

        if renpy.variant("pc") or renpy.variant("web"):
            use settings("Display"):
                style_prefix "radio"
                textbutton _("Window"):
                    # Ensures this button is selected when
                    # not in fullscreen.
                    selected not preferences.fullscreen
                    action Preference("display", "window")
                textbutton _("Fullscreen"):
                    action Preference("display", "fullscreen")
        
        ### SKIP ###
        use settings("Skip"):
            style_prefix "check"
            textbutton _("Transitions"):
                action InvertSelected(Preference("transitions", "toggle"))
            textbutton _("Unseen Text"):
                action Preference("skip", "toggle")
            textbutton _("After Choices"):
                action Preference("after choices", "toggle")
                xsize 350

        ### CUSTOM CURSOR ###
        use settings("Mouse Cursor"):
            style_prefix "check"
            textbutton _("Disable custom cursor"):
                action Preference("system cursor", "toggle")
                tooltip _("Check if you want to use your system's default cursor.")
        
        ### SPRITES ANIMATIONS ###
        use settings("Character Animations"):
            style_prefix "radio"
            textbutton _("All"):
                action SetVariable("persistent.char_animations","all")
                tooltip _("If checked, character animations such as jumping\nor shaking will be displayed.")
            textbutton _("Mild"):
                action SetVariable("persistent.char_animations","mild")
                tooltip _("If checked, character animations will be displayed,\nbut the more intense variants won't be used.")
            textbutton _("None"):
                action SetVariable("persistent.char_animations","none")
                tooltip _("If checked, no character animation will be displayed.")
        
        ### AUTO HIGHLIGHT ###
        use settings("Highlight Speaker"):
            style_prefix "radio"
            textbutton _("On"):
                action SetVariable("persistent.autohighlight",True)
                tooltip _("Highlights the character currently speaking,\nthen un-highlights them when they stop speaking.")
            textbutton _("Off"):
                action SetVariable("persistent.autohighlight",False)
                tooltip _("Doesn't highlight the character currently speaking.")
        
        use settings("Moon Bar"):
            style_prefix "radio"
            textbutton _("On"):
                action SetVariable("persistent.moon_bar",True)
                tooltip _("Displays the moon bar after the introductory sequence.")
            textbutton _("Off"):
                action SetVariable("persistent.moon_bar",False)
                tooltip _("Doesn't display the moon bar after the introductory sequence.")


    $ tooltip = GetTooltip()

    if tooltip:
        nearrect:
            focus "tooltip"
            prefer_top True

            frame:
                xalign 0.5
                padding (15,10)
                text tooltip


############################################################
### PREFERENCE - TEXT SCREEN ###
############################################################
screen pref_text():
    vbox:
        null height 140
        spacing 20

        ### FONT SIZE ###
        use settings("Text Size"):
            style_prefix "radio"
            textbutton _("Default"):
                action Preference("font size", 1.0)
            textbutton _("Large"):
                action Preference("font size", 1.2)

        use settings("Game Font"):
            style_prefix "radio"
            textbutton _("IM Fell English"):
                action Preference("font transform", None)
            textbutton _("{font=DejaVuSans.ttf}DejaVu Sans"):
                action Preference("font transform", "dejavusans")
                xsize 500

        ### TEXTBOX OPACITY ###
        use settings("Textbox Opacity"):
            style_prefix "slider"
            bar value FieldValue(persistent, "say_window_alpha", range=1.0, max_is_zero=False, offset=0, step=.2) alt _("Change textbox opacity.")
        

        ### TEXT SPEED ###
        use settings("Text Speed"):
            style_prefix "slider"
            bar value Preference("text speed") alt _("Text speed.")
        
        
        ### AUTO FORWARD ###
        use settings("Auto-Forward Time"):
            style_prefix "slider"
            bar value Preference("auto-forward time")


############################################################
### PREFERENCE - SOUND SCREEN ###
############################################################
screen pref_sound():
    vbox:
        null height 140
        spacing 20

        ### MUSIC ###
        if config.has_music:
            use settings("Music Volume"):
                style_prefix "slider"
                bar value Preference("music volume"):
                    tooltip _("Volume of music.")
        

        ### SFX ###
        if config.has_sound:
            use settings("Sound Volume"):
                style_prefix "slider"
                bar value Preference("sound volume"):
                    tooltip _("Volume of sound effects, such as footsteps or slashes.")
                if config.sample_sound:
                    textbutton _("Test") action Play("sound", config.sample_sound) alt "Play test sound effect":
                        activate_sound Null
        
        
        ### YAP SOUNDS ###
        use settings("Yap Volume"):
            style_prefix "slider"
            bar value Preference("yap volume"):
                    tooltip _("Volume of dialogue sounds.")
            textbutton _("Test") action Play("yap", sample_yap, selected=True) alt "Play test dialogue sound":
                activate_sound Null
        

        ### AMBIENT VOLUME ###
        use settings("Ambient Volume"):
            style_prefix "slider"
            bar value Preference("ambient volume"):
                    tooltip _("Volume of ambient sounds, such as a campfire,\nthe ocean or the rain.")
        

        ### AMBIENT VOLUME ###
        use settings("UI Volume"):
            style_prefix "slider"
            bar value Preference("ui volume"):
                    tooltip _("Volume of menu buttons.")
        
        
        ### VOICE ###
        if config.has_voice:
            use settings("Voice Volume"):
                style_prefix "slider"
                bar value Preference("voice volume")
                if config.sample_voice:
                    textbutton _("Test") action Play("voice", config.sample_voice)
        

        ### MUTE ALL ###
        if config.has_music or config.has_sound or config.has_voice:
            use settings("Mute Game"):
                style_prefix "check"
                textbutton _("Mute everything"):
                    #style_prefix "check"
                    action Preference("all mute", "toggle")

        $ tooltip = GetTooltip()

    if tooltip:
        nearrect:
            focus "tooltip"
            prefer_top True

            frame:
                xalign 0.5
                padding (15,10)
                text tooltip


############################################################
### PREFERENCE STYLES ###
############################################################
style pref_hbox:
    pos (0.5, 0.0)
    anchor (0.5, 0.0) 
    xoffset 175
    spacing 30
    top_padding 0
    size 52

style pref_button:
    xysize (275, 149)
    align (0.5, 0.5)

    idle_background None
    #hover_background "gui/button/btn_tab_selected.webp"
    #selected_background "gui/button/btn_tab_selected.webp"

style pref_button_text:
    size 40
    align (0.5, 0.5)



                

      

                

### PREF
style pref_label:
    top_margin 15
    bottom_margin 3

style pref_label_text:
    yalign 1.0

style pref_vbox:
    xsize 338

## RADIO
style radio_label:
    is pref_label

style radio_label_text:
    is pref_label_text

style radio_vbox:
    is pref_vbox
    spacing 0

style radio_button:
    foreground "gui/button/radio_[prefix_]foreground.png"
    padding (35, 6, 6, 6)

## CHECK
style check_label:
    is pref_label
style check_label_text:
    is pref_label_text

style check_vbox:
    is pref_vbox
    spacing 0

style check_button:
    foreground "gui/button/check_[prefix_]foreground.png"
    padding (35, 6, 6, 6)

## SLIDER
style slider_label:
    is pref_label
style slider_label_text:
    is pref_label_text

style slider_slider:
    xsize 525

style slider_bar:
    is slider_slider

style slider_button:
    yalign 0.5
    left_margin 15

style slider_vbox:
    is pref_vbox
    xsize 675

