## Character declarations

#################################################################################################

define l = Character("[lou_name]", image="lou", color="#4FA9D6", callback = [name_callback, lou_sounds], cb_name = "lou")
define c = Character("[cyn_name]", image="cynthia", color="#d6bd4f", callback = [name_callback, cynthia_sounds], cb_name = "cynthia")
define G = Character("[gar_name]", image="garland", color="#75b44c", callback = [name_callback, garland_sounds], cb_name = "garland")
define B = Character("The Beast", color="#FF2652", callback = beast_sounds)

define narrator = Character(callback = name_callback, cb_name = "")

### Character Images Declarations ###############################################################

#################################################################################################

# Garland layers
layeredimage garland:
    at sprite_highlight('garland')
    group body auto:
        attribute base default
    group robe auto:
        attribute robeon default
        attribute robeoff:
            Null()
    group face auto:
        attribute neutral default

# Cynthia layers
layeredimage cynthia:
    xzoom -1.0
    at sprite_highlight('cynthia')
    group base auto:
        attribute base default
    group face auto:
        attribute neutral default
    group hat auto:
        attribute decoration default

# Lou layers
layeredimage lou:
    at sprite_highlight('lou')
    group body auto:
        attribute base default
    group clothes auto:
        attribute main default
    attribute hair default
    group face auto:
        attribute neutral default
    group robe auto

layeredimage lou ww:
    at sprite_highlight('lou')
    group body auto:
        attribute base default
    group face auto:
        attribute neutral default

# image side lou = LayeredImageProxy("lou", Transform(crop=(0, 0, 1.0, 0.425), xoffset=-200))


### Image Declarations ##########################################################################

#################################################################################################
image spooktober = "spooktober.webp"
image slash1 = "cg/action/simple_slash_5_blood.webp"
image slash2 = "cg/action/battle_effect_1d.webp"
image slash3 = "cg/action/battle_effect_5d.webp"

image blood1 = "cg/action/blood1.webp"
image blood2 = "cg/action/blood2.webp"
image blood3 = "cg/action/blood3.webp"
image blood4 = "cg/action/blood4.webp"

image scare_text = ParameterizedText(textalign=0.5, size=600, font="MetalMania-Regular.ttf", line_spacing=-220, yoffset=-100, 
color="#FF2652", xfill=True, outlines=[(absolute(3), "#000", absolute(0), absolute(1))])

### Music declarations ##########################################################################
# default config.main_menu_music = "main-menu-theme.ogg"

define audio.dark_song = "music/eternal_darkness_loop.ogg"
define audio.wolf_hunger = "music/abyss_of_despair.ogg"
define audio.truth = "music/to_tell_the_truth.ogg"
define audio.nostalgia = "music/nostalgia.ogg"
define audio.fight = "music/dinosaur_world_loop.ogg"


## SFX and Ambient Declarations #################################################################

#################################################################################################
define audio.rainthunder = "<volume 0.95>sfx/freesound_community_rain_thunder.ogg"
define audio.rain = "<volume 0.95>sfx/freesound_community_rain.ogg"
define audio.campfire = "sfx/fire-340951.ogg"

define audio.fire1 ="sfx/fire-magic-5-378639.ogg"
define audio.scare ="sfx/thriller-score-horror-scene-6730.ogg"

define audio.slice1 = "sfx/sword-slice-2-393845.ogg"
define audio.slice2 = "<volume 0.9>sfx/violent-sword-slice-393839.ogg"

define audio.wound1 = "sfx/universfield_wound_bone.ogg"
define audio.wound2 = "sfx/wound_slash_tear2.ogg"
define audio.wound3 = "sfx/wound_blood_splatter.ogg"

define audio.beasteat = "sfx/freesound_community_eating_flesh.ogg"
define audio.growl = "sfx/growl.ogg"

define audio.footstep_slow = "sfx/footsteps_slow.ogg"
define audio.footstep_slow2 = "<to 0.3>sfx/footsteps_slow.ogg"
define audio.footstep_mud1 = "sfx/footsteps_mud1.ogg"
define audio.footstep_mud2 = "sfx/footsteps_mud2.ogg"
define audio.footstep_mud3 = "sfx/footsteps_mud3.ogg"

define audio.boom = "<volume 0.7>sfx/dark_drum.ogg"
define audio.slam ="sfx/crash.ogg"

## Transformations Declarations

#################################################################################################
transform leftish:
    zoom 0.9
    xcenter 0.25
    ypos 1.15
    yanchor 1.0
    zpos 0
    matrixtransform RotateMatrix(0.0, 0.0, 0.0)

transform rightish:
    zoom 0.9
    xcenter 0.75
    ypos 1.15
    yanchor 1.0
    zpos 0
    matrixtransform RotateMatrix(0.0, 0.0, 0.0)

transform kneeling:
    xcenter 0.625
    yanchor 1.0 ypos 1.25
    matrixtransform RotateMatrix(0.0, 0.0, -30.0)
    zpos 750

transform sideimage:
    zoom 0.9
    xpos -0.075 ypos 0.61

transform jumper:
        ease .04 yoffset 24 
        ease .04 yoffset 20 
        ease .03 yoffset 16 
        ease .02 yoffset 12 
        ease .01 yoffset 8 
        ease .01 yoffset 4 
        ease .01 yoffset 0 

transform bigjumper:
        ease .06 yoffset 24
        ease .06 yoffset -24
        ease .05 yoffset 20
        ease .05 yoffset -20
        ease .04 yoffset 16
        ease .04 yoffset -16
        ease .03 yoffset 12
        ease .03 yoffset -12
        ease .02 yoffset 8
        ease .02 yoffset -8
        ease .01 yoffset 4
        ease .01 yoffset -4
        ease .01 yoffset 0

transform blank:
    pass

## Camera transforms & variable

#################################################################################################
transform cam_garland(x=0, y=0, z=0):
    xpos x ypos y zpos z
    easeout 0.75 xpos -550 ypos -150 zpos -400


transform cam_cynthia(x=0, y=0, z=0):
    xpos x ypos y zpos z
    easeout 0.75 xpos 540 ypos 0 zpos -400


transform cam_cyngar(x=0, y=0, z=0):
    parallel:
        xpos x
        easeout 0.75 xpos 0
    
    parallel:
        ypos y
        easeout 0.75 ypos 0
    
    parallel:
        zpos z
        easeout 0.75 zpos 0


## Variable Transform function for accessibility  
init python:
    def bump(jumper):
        if persistent.char_animations != "none":
            return jumper
        else:
            return blank


    def bump(bigjumper):
        if persistent.char_animations == "all":
            return bigjumper
        elif persistent.char_animations == "mild":
            return jumper
        else:
            return blank

## Game Variables

#################################################################################################
default cynset = set()
default garset = set()

default cyn_name = "{noalt}???????{/noalt}{alt}Unknown{/alt}"
default gar_name = "{noalt}???????{/noalt}{alt}Unknown{/alt}"
default lou_name = "Lou"

default moon = 0 #each moon increase being +8 should give a total of 15 interactions per run
default hungry = False

default forgarlic = False

# Ending tracking

#################################################################################################
default cynpoints = 0
default cyntalks = 0
default garpoints = 0
default gartalks = 0

# Ending and achievements tracking
default forgot = 0
default serious = 0
default garblush = 0
default dog = 0

default persistent.fadetoblack = False
default persistent.whatthedog = False

default persistent.garlandplat = False
default persistent.garlandrom = False

default persistent.cynthiaplat = False
default persistent.cynthiarom = False

default persistent.tripleplat = False
default persistent.triplerom = False

default persistent.reign = False
default persistent.twisttheknife = False

# Ending dialogue
default end_type = ""

# Cynthia talks

#################################################################################################
default talk_week = False
default talk_country = False
default talk_antidote = False
default talk_magic = False

default emotional_focus = False
default cyn_focus = False
default cyn_dad = False

default talk_loufamily = False
default silver_dagger = False
default lou_focus = ""

default cynthia_minotaur = False

# Garland talks

#################################################################################################
default garstare = 0
default talk_garlandself = False

default talk_cook = False
default garlandhobbies = False
default held_enough = False

default jocosa_cynthia = False
default gar_family = 0

default talk_garmonsterhunter = False
default garland_cold = False
