
## Main Menu screen ############################################################
##
## Used to display the main menu when Ren'Py starts.
##
## https://www.renpy.org/doc/html/screen_special.html#main-menu

## Replace this with your background image, if you like
image main_menu_background = Image("gui/titlescreen/bg_titlescreen.webp", oversample=1.5)

image main_menu_rain:
    Image("gui/titlescreen/titlescreen_rain1.webp", oversample=1.5)
    pause 0.1
    Image("gui/titlescreen/titlescreen_rain2.webp", oversample=1.5)
    pause 0.1
    Image("gui/titlescreen/titlescreen_rain3.webp", oversample=1.5)
    pause 0.1
    Image("gui/titlescreen/titlescreen_rain4.webp", oversample=1.5)
    pause 0.1
    Image("gui/titlescreen/titlescreen_rain5.webp", oversample=1.5)
    pause 0.1
    repeat

screen main_menu():

    ## This ensures that any other menu screen is replaced.
    tag menu

    on "show" action Play("ambient", "<volume 0.95>sfx/freesound_community_rain_thunder.ogg", fadein=0.25)
    on "hide" action Stop("ambient", fadeout=1.0)

    add "main_menu_background"
    add "main_menu_rain"

    vbox:
        xalign 0.5 xoffset 10
        ycenter 0.9 yoffset -15
        spacing 0

        hbox:
            spacing 35
            xalign 0.5

            style_prefix "main_menu"

            textbutton _("Start") action Start():
                text_size 52

            textbutton _("Load") action ShowMenu("load"):
                text_size 52
           
            if (persistent.fadetoblack or persistent.whatthedog or 
                    persistent.garlandplat or persistent.garlandrom or 
                    persistent.cynthiaplat or persistent.cynthiarom or 
                    persistent.tripleplat or persistent.triplerom or 
                    persistent.reign or persistent.twisttheknife):

                textbutton _("Gallery") action ShowMenu("gallery"):
                    text_size 52

        hbox:
            spacing 35
            xalign 0.5
            
            style_prefix "main_menu"

            textbutton _("Settings") action ShowMenu("preferences")

            textbutton _("Achievements") action ShowMenu("achievement_gallery")

            textbutton _("About") action ShowMenu("about")

            if renpy.variant("pc") or (renpy.variant("web") and not renpy.variant("mobile")):

                ## Help isn't necessary or relevant to mobile devices.
                textbutton _("Controls") action ShowMenu("help")

            if renpy.variant("pc"):

                ## The quit button is banned on iOS and unnecessary on Android and
                ## Web.
                textbutton _("Quit") action Quit(confirm=not main_menu)

## Button Styling
style main_menu_button:
    xalign 0.5

style main_menu_button_text:
    is button_text
    idle_color '#fff0f5'
    hover_color '#FF2652'
    size 48
    outlines [ (3, "#000", 0, 1) ]
    textalign 0.5