﻿# The game starts here.

label start():
    $ narrator = nvl_narrator

    play music dark_song

    play ambient rainthunder fadein 0.5
    queue ambient rain

    scene black

    "I've always hated the rain."
    extend " Whether it's tonight, last week or anything that came before, nothing good has ever happened to me on a rainy day."

    nvl clear

    play sound footstep_mud1
    
    pause 0.05
    
    play audio footstep_mud2
    
    pause 0.1

    play audio footstep_mud3

    pause 0.1

    "Muddy footsteps. Heavy breaths. Shouts. Torches. Pitchforks.{w} They're after me."
    extend " I curse under my breath as I almost slip and fall into a murky puddle."
    "It's not that I can't take on a few peasants. Even someone like me could do it.{w} I just don't have it in me to kill a bunch of innocent people. As stupid as they may be."
    "Not sure the {color=#FF2652}freaking beast{/color} would say the same though."

    "I grit my teeth at this thought and turn to a familiar cave."

    window show

    nvl clear

    scene bg cave_outside:
        zoom 0.5
    
    with dissolve

    "Shit. How did I forget that it's a dead end?"
    extend " By the time I turn back, they're already waiting for me."
    "Their silhouettes appear clear to me against the pale moonlight.{w} I catch a glimpse of a bow aimed at me and my heart skips a beat."
    extend " Moments later I feel a deep, sharp pain." 
    extend " Not from an arrow, but from my body contorting, expanding and being torn apart."

    play sound growl
    stop music fadeout 2.0

    "Once the moon rises high enough to shine on me, the only thing they can see is {color=#FF2652}the beast{/color}." 
    extend " And the hunters become prey."

    nvl clear
    "{nw}"

    play sound slice1

    play music wolf_hunger

    scene slash1 at truecenter:
        zoom 1.05
    with CropMove(0.15,mode="wipedown")

    pause 0.1

    play sound wound1

    nvl clear

    "The sound of broken bones is covered by a cry of agony."

    play sound slice2
    pause 0.05
    scene slash2 at truecenter:
        zoom 1.0
        easein_bounce 0.5 zoom 0.8

    "In a single swoop, the second villager no longer has a mouth to scream with."

    scene black with dissolve

    play sound wound2
    show blood1

    pause 1.0
    play sound wound3
    show blood3

    pause 1.0
    play sound wound1
    show blood4

    pause 1.5

    nvl clear 
    with dissolve

    "I remain frozen as a metallic scent twists my stomach."
    extend " One of my eyes tears up."
    "I want to leave, get away and forget it all, but {color=#FF2652}the beast{/color} won't let me."

    play sound beasteat loop

    extend " Instead it gets closer to the bloodbath and starts feasting." 
    "Its maw can't distinguish flesh from bone."
    "I feel like puking, yet a smile deforms what used to be my face."
    "It's like I'm..."
    extend " fading away."

    nvl clear

    "Chewing my own limbs, I'm the last to go." 
    "Only {color=#FF2652}the beast{/color} remains."

    window auto

    nvl clear
    stop ambient fadeout 3.5
    stop music fadeout 3.5
    stop sound fadeout 4.
    scene black
    with Dissolve(3.0)


label introduction:    
    pause 2.0

    $ narrator = adv_narrator
    $ nvl_quick_menu = False

    c "Lou?"

    window show

    if not _preferences.self_voicing:
        "..."

    c "Hey! Lou!"

    camera:
        perspective True
        #gl_depth True

    scene bg cave:
        zoom 0.9 xcenter 0.5 ycenter 0.5
        zpos -200
        zzoom True

    show cynthia shocked at kneeling
    with dissolve

    "A tug pulls me out of this bloody nightmare. {w}My eyes open wide to Cynthia's face."

    $ cyn_name = "Cynthia"

    c concerned "You good? You're sweating a lot."

    alt "She's kneeling down next to me with an arched eyebrow, her pointy hat almost slipping off."

    show lou away onlayer yapimage at sideimage

    l away "I'm... I'm fine. I've been better, but I'm fine."

    show cynthia smile at rightish
    with dissolve

    "She offers me a sorry smile {alt}and stands back up {/alt}before continuing."

    c neutral "Good. I have the antidote."

    show lou neutral

    "My breath finally steadies as I scratch my neck,{nw}" 

    show lou concerned at bump(jumper)
    
    extend " but I frown soon after."

    l "Is that... Is your antidote the thing that smells so terrible?"

    c concerned "Huh? What are you talking about?"

    l "Don't you smell anything???"

    G "Do you mean the smell of the fish I caught?"

    play sound footstep_slow

    "Garland approaches from behind Cynthia, towering above the both of us and brandishing a handful of tenches."
    
    show garland at leftish:
        zpos -150
    with dissolve

    $ gar_name = "Garland"

    pause 0.5

    l "No, the fish smell was pretty obvious."

    G "Good. I went out of my way to get you some since you looked so meat-averse yesterday."

    "That's right. I started thinking that eating meat could wake up {color=#ff4040}the beast{/color} earlier than we predicted. 
    And the dream I just had doesn't help at all."

    "I almost want to smile at his thoughtfulness,{nw}" 
    
    show lou wince2 

    extend " but I end up rubbing my nose and staring at all the fish he's holding."

    show lou concerned at bump(jumper)

    l "What did you do to the fish?"

    alt "He looks confused."

    G concerned "Well... {w}I seasoned it in advance? As I usually do?"

    l "Seasoned them with what?"

    play sound footstep_slow2

    show garland:
        subpixel True
        zoom 0.9
        zpos -150
        easein 1.5 zpos 0

    "He approaches while holding back a sigh. I can tell."

    c shocked "Is it the smell of garlic that messes with you?"

    alt "My eyes widen."

    show lou at bump(jumper)

    l "You put garlic in the fish?!"

    G -concerned "Yes. Obviously."

    show lou at bump(jumper)

    l "Why would you though?"

    G sigh "Why? Well, we have to eat all of that extra garlic since {i}someone{/i} insisted we get ten kilograms."

    menu:
        "“Did I do that?”":
            l shocked "Did I do that?"
            jump did_i_do_that

        "“That sounds familiar.”":
            l neutraln "That sounds familiar."
            jump sounds_familiar


label did_i_do_that:
    c concerned "Are you serious?"

    G -sigh "Yes. Yes, you did do that, Lou."

    l concerned "That doesn't sound right."

    if _preferences.self_voicing:
        show garland sigh
        "He sighs."
    else:
        G sigh "Ugh..."

    c concerned "I guess you're really not feeling good after all."

    show cynthia concerned

    extend " Remember that vampire we beat up last month?"

    l neutraln "Vaguely."

    alt "I think that made her cringe for some reason."

    c away "As usual, you wanted to be ready for every single scenario. This time, you decided to go ham on the garlic."

    l grin "If garlic wasn't so awful I'd say “nice joke”."

    c what "That wasn't a joke."  

    show lou concerned

    G away "You used to like garlic so much though..."
    
    $ forgarlic = True
    $ forgot += 1
    $ serious += 1

    l neutraln "I don't believe you."

    show garland sigh

    alt "Garland sighs. Again."

    c away "Perhaps that has something to do with the werewolf curse?"
    
    jump the_antidote


label sounds_familiar:

    c "I sure hope it does!"

    show cynthia concerned

    extend " Didn't you think ten kilograms was a bit excessive for a single vampire?"

    l concerned "I didn't know if it was the kind of vampire that could fly. I needed good ammunition for my sling as a backup!"

    G -sigh "Ten kilograms Lou. Ten kilograms."

    l "Maybe that bitch had thralls for all we knew at the time!"

    G away "To be fair, we didn't try to stop you."

    c "Hey that's not true! I got him to buy ten instead of sixteen!"

    G -away "Ah, you're right..."
    
    show garland away

    extend " He used to like garlic so much though..."

    l neutraln "Yeah, and I also used to not have a werewolf curse."


label the_antidote:  

    l away "{nw}"
    
    "I look at my left shoulder. No wound, just a scar, but it's tightly bandaged to avoid even the smallest glimmer of moonlight."

    c away "Your sudden change of tastes is pretty concerning. You've been eating garlic just fine for a month now."

    if forgot:
        "I don't believe her either but I'm gonna shut up this time."
    
    "Rummaging through her satchel, she pulls out a bottle containing a really weird liquid. It's hard to make out, but I see colors swirling. Brown and purple?"

    c neutral "Here you go, friendo. Make sure to pinch your nose as you drink it."

    alt "I frown."

    l concerned "Why?"

    c away "To make the taste less... strong."

    menu:
        "“If you say so.”":
            l neutral "If you say so."
            jump listened_cynthia

        "“Nah I'd win.”":
            l neutral "Nah, I can take it."
            jump notlistened_cynthia


label listened_cynthia:

    """
    No reason to doubt her at this point. Over the last few months, Cynthia proved to be a knowledgeable and reliable alchemist, and also a talented pyromancer.

    She did predict the possibility of a curse, and thanks to that I made sure to avoid moonlight for the past week.

    I don't want to imagine how bad the nightmares, itching and headaches would have gotten by now if I didn't know.
    """

    play sound boom

    show lou wince2 at bump(bigjumper)

    "Oh shoot! She was right again. How can something taste so awful?! I shiver and stick out my tongue."

    c neutral "Oh, maybe it's worse now, since you suddenly hate garlic. There's some in it."

    if _preferences.self_voicing:

            alt "I let out a moan of despair."

            l "You could have told me!"

    else:

        l "Ugh... You could have told me!"

    c smile "Mm, no. I think ignorance is bliss in cases like this one!"

    jump lighter


label notlistened_cynthia:

    alt "She rolls her eyes."

    c shocked "Are you for real?" 

    show cynthia concerned

    c "I get the stress, but I didn't think the full moon would make you act up this badly."

    "I shrug and grab the potion. There's not that much of it anyway. How bad can it be?"

    show lou wince2 at bump(bigjumper)

    show garland neutral
    show cynthia neutral

    play sound boom

    """
    Shit shit shit. Really bad is the answer! And I made the mistake of swallowing it all in one go too!{w} Bitter. Spicy. Muddy. Metallic. My mouth dries up instantly.

    I try to spit it out but it's too late at this point.
    """
    
    show garland at bump(jumper)
    pause 0.1
    show garland at bump(jumper)

    G smile "Heh... Hehe..."
    
    if persistent.char_animations == "mild":
        show cynthia at bump(jumper)
        pause 0.1
        show cynthia at bump(jumper)
        pause 0.1
        show cynthia at bump(jumper)

    else:
        show cynthia at bump(bigjumper)
    
    c creepers "Hahahahaha!"

    show lou at bump(jumper)

    "These fuckers. I try to pout but I can't with my mouth like this. I just wince more instead."

    $ serious += 1

    show lou at bump(jumper)

    l "You're so mean to me!"

    "I stick out my tongue out of digust, hoping it'll get rid of the taste."

    c concerned "I told you to pinch your nose!"

    show cynthia creepers

    extend " But I guess I didn't tell you there was garlic in the antidote."

    show cynthia -creepers

    extend " That's on you for being so stubborn, honestly."


label lighter:
    
    G neutral "Cynthia, could you light a fire so that I can cook my disgusting garlic fish please?"

    show cynthia at bump(jumper)

    play sound fire1

    "With a flick of the wrist, a flame appears at the tip of her thumb." 

    show bg cave at CampfireLightingback
    show lou at CampfireLighting
    show garland at CampfireLighting
    show cynthia neutral at CampfireLighting

    with Dissolve(0.2)

    play ambient campfire volume 0.7 fadein 1.0
    
    show lou away
    
    #TODO: shader stuff

    extend " She uses it to light up some wood that they probably dropped there when they found me unconscious."

    "I've seen it countless times now, but I find the fire very beautiful tonight. {w}I can't even blink.{w} Not until{nw}"
    
    #### scare sequence
    show black with Dissolve(0.2)
    play sound scare
    $ quick_menu = False
    window hide

    show lou shocked at bump(bigjumper)

    show blood2:
        alpha 0.75
    show scare_text "KILL THEM" at truecenter:
        zoom 3.0
        easein_bounce 0.25 zoom 0.7

    pause 0.05

    show lou shocked

    pause 1.25
    
    hide scare_text
    hide blood2
    with Dissolve(0.5)

    show lou shocked at bump(jumper)

    $ quick_menu = True
    window auto

    if _preferences.self_voicing:
        "What was that?!"
    else:
        "{color=#FF2652}{size=*2.5}?!?!?!?!?!?!"

    "I feel pressure in the back of my head..."
    
    hide black
    with Dissolve(0.5)
    ####

    c smile "What? Finally appreciating my “lighter trick”?"

    "Calm down, act cool. No need to be even more of a burden."

    menu:

        "“It's pretty handy.”":
            l neutral "It's pretty handy."

            show lou smile

            extend " I actually hate making my own fires now."

            c smile "Whoa, this is music to my ears."


        "“Light her? I hardly know her.”":
            l neutral "Light her? I hardly know her."
    
            show cynthia at bump(bigjumper)
            
            c creepers "Hahahahaha!"
            $ cynpoints += 1

            c smile "Kind of unusual coming from you."

            l "Very few things are like usual right now."

            c away "I can imagine."

            "Her eyes lower to my shoulder before turning to the fire."


        "Bark":
            show lou at bump(jumper)
            "A bark escapes me. And then another. My chest feels lighter."
            
            c what "Are you... Are you being serious right now?"

            "I blink a lot."

            l "Huh? Uh, no... I don't know what got into me."
            $ serious += 1
            $ dog += 1

            if _preferences.self_voicing:
                c "Right..."
            else:
                c "Riiight..."
            
            menu:
                "Shut up":
                    pass
                
                "Get one last bark out":
                    show lou at bump(jumper)
                    "I bark one last time. That feels good. That feels right. I don't know why."

                    $ dog += 1
                    show cynthia what
                    show garland at bump(jumper)

                    G "I don't know what's going on with you but... it is pretty funny. {w}And a bit scary."

    show black 
    
    show lou away

    with dissolve

    show garland neutral:
        zpos -75
        xcenter 0.20
    show cynthia neutral:
        zpos -75
        xcenter 0.80

    pause 0.5

    hide black with dissolve 

    """
    The three of us are now sitting in a circle as the smell of cooked fish fills the air.{w} After that antidote, even the garlic is comforting.

    The only thing breaking the silence is the crackling of the fire.

    I can't tell if they're being carefree or if they're trying to ignore our... situation and hide their worry. But I'm on a time limit. I'm sure of it.

    Not that I don't trust Cynthia but... is the antidote really going to work this late? It's been a whole week.{w} Once the full moon is out, things might change forever.
    
    Our next conversation could be our last and the thought makes me want to bite my nails.

    My sister often said that trauma dumping is better and more intimate than small talk. 
    
    But no matter how much I want to say what I have on my mind, I also don't want them to remember me as some pathetic guy.
    """
                    


label yap_hub:
    camera at cam_cyngar
    with dissolve

    #Hunger conversation
    if moon >= 54 and not hungry:
        jump hungry

    # checking for ending conditions
    if dog >= 3:
        $ moon =+ 60
        pause 0.1
        hide screen moon_bar with dissolve

        jump what_the_dog #silly ending
    
    if forgot >= 6:
        hide screen moon_bar with dissolve
        
        jump fade_to_black #dark-ish ending
    
    if moon >= 112: # regular endings
        hide screen moon_bar with dissolve

        if garpoints <= 4 and cynpoints <= 4:
            jump reign_in_blood # bad end ## if I do implement the solitude ending, the conditions should be <=3 instead of 4 
        
        elif garpoints >= 5 or cynpoints >= 5:
            jump together # good end

        # elif garpoints == 4 or cynpoints == 4:
        #     jump solitude ## cut ending


    show screen moon_bar()
    with dissolve

    menu:
        "Talk with who?"
        
        "Look to Garland":
            jump garland 

        "Look to Cynthia":
            jump cynthia



label cynthia:

    camera at cam_cynthia(x=0, y=0, z=0)

    # check for special conversation conditions
    if held_enough and cyn_dad and gar_family and not talk_loufamily:
        jump talk_loufamily

    if (cynpoints >= 2 or moon >= 90) and talk_antidote and not cynthia_minotaur:
        jump cynthia_minotaur

    menu:

        set cynset
        "Talk about what?"

        "“How was your week? Must have been tough.”":
            jump talk_week

        "“What's your country like?”" if talk_week:
            jump talk_country

        "“About that antidote...”" if talk_magic:
            jump talk_antidote

        "Teaching magic" if talk_country:
            jump talk_magic

        "“What's your emotional focus?”" if emotional_focus:
            jump cyn_focus

        "“So what's the plan?”" if talk_antidote:
            jump talk_plan

        "“What about your family?”" if gar_family or cyn_focus:
            jump talk_cynfamily

        "“Cynthia, I was thinking...”":
            jump talk_drown

        "Nevermind":
            $ cynset.remove("Nevermind")
            jump yap_hub



label garland:

    if (not garland_cold and ((garpoints >= 2 and moon >= 40) or (moon >=90))):
        jump garland_cold

    camera at cam_garland(x=0, y=0, z=0)

    # check for special conversation conditions
    if gartalks >= 4 and not talk_garmonsterhunter:
        jump talk_garmonsterhunter

    menu:

        set garset
        "Talk about what?"

        "“Where did you learn how to cook?”":
            jump talk_cook

        "“What was your family like?”" if talk_cook:
            jump talk_garfamily

        "“Tell me about this maid.”" if talk_cook:
            jump talk_maid 

        "“Tell me more about yourself.”" if talk_cook:
            jump talk_garlandself

        "“What kind of books do you like?”" if garlandhobbies or cyn_focus:
            jump talk_garbooks

        "“What kind of music do you like?”" if garlandhobbies:
            jump talk_garmusic

        "Stare at him":
            jump garstare1

        "Stare again" if garstare == 1:
            jump garstare2

        "Nevermind":
            $ garset.remove("Nevermind")
            jump yap_hub


label hungry:
    show lou wince2 -blush

    "My stomach grumbles. With a slight wince I put a hand on it."

    l concerned "I'm so{noalt}oo{/noalt} hungry."

    show garland neutral -blush

    c neutral "Then eat?"

    l "Duh."

    G "It {i}is{/i} ready, if you want."

    l away "But the garlic..."

    c smile "You only have yourself to blame."

    if forgarlic:
        l neutraln "I don't believe you."

        c what "You don't have to."

        show cynthia neutral

    else:
        l "Fine..."

    "Either way, I'm not going to spit on food that was made for me. Mom would kill me. And..."

    l neutral "I do appreciate the gesture though."

    G "I am glad."

    play music wolf_hunger fadein 5.0

    "He says it with his usual, impassive tone, but I know he means it.{w} Still... I could be eating real meat." 

    show lou concerned at bump(jumper)

    extend " Wait, no! What am I thinking? No meat until this whole werewolf thing is behind me!"

    "I dig in to get rid of the idea, my mouth opening almost like a maw."

    show garland concerned at bump (jumper)

    G "I uh... didn't remove the bones you know?"
    
    #### scare animation
    show black behind garland, cynthia:
        zpos -75
        zzoom True
    show blood3 behind garland, cynthia:
        zpos -75
        zzoom True
    
    play sound scare
    with Dissolve(0.2)
    ####

    l grin "It's fine, I'm so hungry I could eat you up."

    show cynthia what

    G shocked "I... I don't think you could, even if you wanted to."

    show lou concerned

    "Wait. Did I say that out loud?"

    l "Why not?"

    "My head hurts."

    G "I'm almost twice your size, and... I don't think it would be great to chew through all of those muscles."

    l "Huh. You do have a point there.{nw}" 

    show lou grin
    show blood4 behind garland, cynthia:
        zpos -75
        zzoom True

    extend " I guess it'd make more sense to eat Cynthia instead."

    show cynthia at bump(jumper)

    c "Alright, we're ending this bit right here. I'm trying to eat."

    G neutral "Apologies."

    show lou away

    "Did I really say all those things?{w} I want to apologize too, but nothing comes out.{w} I'm too busy biting the inner sides of my lips, my cheeks and... The realization almost makes me want to tear up but I..."
    
    show blood1 behind garland, cynthia, blood3, blood4:
        zpos -75
        zzoom True
    
    show blood2 behind garland, cynthia:
        zpos -75
        zzoom True

    with dissolve

    "I enjoy the taste of my blood."

    "I look down at the fish I'm holding and... whoa." 
    
    show lou concerned
    
    "I couldn't even distinguish flesh from bone while I was chewing."

    show lou away

    "Am I... becoming a monster?{w} My chest feels tighter. For a moment, I can't breathe.{w} Then I force myself to eat the rest of the fish, with more care this time. The same way a person would."

    hide black
    hide blood3
    hide blood4
    hide blood2
    hide blood1
    with Dissolve(0.5)

    stop music fadeout 3.0

    "Let's just not think about it. Out of sight, out of mind."

    $ hungry = True
    $ moon += 4
    jump yap_hub